/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#if defined(_MSC_VER)
# pragma data_seg("error_c","FAR_DATA")
#elif defined(__BORLANDC__)
# pragma option -dc
#endif /* _MSC_VER etc. */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include <typedefs.h>
#include <dynamic.h>
#include <errcapi.h>


extern b_errtype BestPattGetEdit(b_handletype handle,
    b_int64 patt_id,
    b_ccharptrtype * pattern);
/*lint -e786 ... String concatenation within initializer */


extern const char perfboard_err[];
extern const char *pcst_list[];
extern const char *verchk_list[];
extern const ErrorDescription CapiErrorStrings[];
extern const ErrorDescription FirmwareErrorStrings[];


#if 1
/* release case:
   bad messages are to be prefered over no messages */

#define B_E_LAST_ENTRY    B_E_COUNT
#define B_EFW_LAST_ENTRY  B_EFW_COUNT

#else

#define B_E_LAST_ENTRY    B_E_MAXERR
#define B_EFW_LAST_ENTRY  B_EFW_MAXERR

#endif


/* Special string-formatting routine to handle 64/32 bit values */
static size_t errsprintf(char *buf, const char *format, b_int64 par1, b_int64 par2, 
                      b_int64 par3, b_int64 par4, b_int64 par5) {
    char outformat[10];
    char *bufmerk=buf;
    char *tmpbuf;
    int parnr=0;
    int l,s,working;
    b_int64 par[5];

    par[0]=par1;
    par[1]=par2;
    par[2]=par3;
    par[3]=par4;
    par[4]=par5;

    while (strchr(format,'%')) {
        memcpy(buf,format,strchr(format,'%')-format);
        buf+=strchr(format,'%')-format;
        format=strchr(format,'%')+1;
        strcpy(outformat,"%");
        working=TRUE;
        l=FALSE;
        s=FALSE;
        while (format[0] && working) {
            switch (format[0]) {
            case 'l': 
                l=TRUE;
                break;
            case 'h':
                s=TRUE;
                break;
            case 'c':
                tmpbuf=(char *)malloc(100*sizeof(char));
                strncat(outformat,&format[0],1);
                sprintf(tmpbuf,outformat,(int)par[parnr]);
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                working=FALSE;
                parnr++;
                break;
#ifndef UNIX
            case 'C':
                tmpbuf=(char *)malloc(100*sizeof(char));
                strncat(outformat,&format[0],1);
                sprintf(tmpbuf,outformat,(wint_t)par[parnr]);
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                parnr++;
                working=FALSE;
                break;
#endif /* UNIX */
            case 'd':
            case 'i':
                tmpbuf=(char *)malloc(100*sizeof(char));
                strncat(outformat,&format[0],1);
                if (l) {
                    sprintf(tmpbuf,outformat,(long)par[parnr]);
                } else if (s) {
                    sprintf(tmpbuf,outformat,(short)par[parnr]);
                } else {
                    sprintf(tmpbuf,outformat,(int)par[parnr]);
                }
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                parnr++;
                working=FALSE;
                break;
            case 'o':
            case 'u':
            case 'x':
            case 'X':
                tmpbuf=(char *)malloc(100*sizeof(char));
                strncat(outformat,&format[0],1);
                if (l) {
                    sprintf(tmpbuf,outformat,(unsigned long)par[parnr]);
                } else if (s) {
                    sprintf(tmpbuf,outformat,(unsigned short)par[parnr]);
                } else {
                    sprintf(tmpbuf,outformat,(unsigned int)par[parnr]);
                }
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                parnr++;
                working=FALSE;
                break;
                break;
            case 'e':
            case 'E':
            case 'f':
            case 'g':
            case 'G':
                tmpbuf=(char *)malloc(100*sizeof(char));
                strncat(outformat,&format[0],1);
                sprintf(tmpbuf,outformat,(double)((signed __int64)par[parnr]));
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                parnr++;
                working=FALSE;
                break;
            case 'n':
                parnr++;
                working=FALSE;
                break;
            case 'p':
                tmpbuf=(char *)malloc(100*sizeof(char));
                strncat(outformat,&format[0],1);
                sprintf(tmpbuf,outformat,(void *)par[parnr]);
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                parnr++;
                working=FALSE;
                break;
            case 's':
                tmpbuf=(char *)malloc((strlen((char *)par[parnr])+1)*sizeof(char));
                strncat(outformat,&format[0],1);
                sprintf(tmpbuf,outformat,(char *)par[parnr]);
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                working=FALSE;
                parnr++;
                break;
#ifndef UNIX
            case 'S':
                tmpbuf=(char *)malloc(wcslen((wchar_t *)par[parnr])*sizeof(char));
                strncat(outformat,&format[0],1);
                sprintf(tmpbuf,outformat,(wchar_t *)par[parnr]);
                strcpy(buf,tmpbuf);
                buf+=strlen(tmpbuf);
                free(tmpbuf);
                parnr++;
                working=FALSE;
                break;
#endif
            case '%':
                strcpy(buf,"%");
                buf++;
                working=FALSE;
                break;
            }
            strncat(outformat,&format[0],1);
            format++;
        }
    }
    strcat(buf,format);
    return (size_t)(buf-bufmerk)+strlen(buf);
}


/* special hack to make core version readable! */
static char *CoreVerString(b_int64 param)
{
  static char buf[10];
  char *bufptr;
  int i;
  strcpy(buf, "R");             /* assume 'R' on all versions... */
  for (i = 2; i >= 0; i--)
  {
    bufptr = buf + strlen(buf);
    sprintf(bufptr, "%c", ((char *) (&param))[i]);  /* convert i'th byte */
    if (i > 0)
      strcat(buf, ".0");
  }
  return buf;
}
/* store an error in case we lost the handle */
static b_lasterrtype es_handleless;
/* store an error in case we do have to make an close afterwards */
static b_lasterrtype es_storeforclose;

static const ErrorDescription * ErrDescFromList(const b_errtype errcode)
{
  int i = 0;
  const ErrorDescription * ep = NULL;

  /* search through all capi errors */
  while (CapiErrorStrings[i].errcode != B_E_LAST_ENTRY)
  {
    if (CapiErrorStrings[i].errcode == errcode)
    {
      ep = &CapiErrorStrings[i];
      break;
    }
    i++;
  }

  /* ok, if not found, search through all firmware errors */
  i = 0;
  while (!ep && FirmwareErrorStrings[i].errcode != B_EFW_LAST_ENTRY)
  {
    if (FirmwareErrorStrings[i].errcode == errcode)
    {
      ep = &FirmwareErrorStrings[i];
      break;
    }
    i++;
  }

  return ep;
}


/* --------------------------------------------------------------------------
 * TODO; this is a rather drastic way of recovering from a bad handle !!!
 * 
 * -------------------------------------------------------------------------- */

static void handle_problem(void)
{

#if 1
  b_handletype handle;
  for (handle = 0; handle < MAXHANDLES; ++handle)
  {
    if (handle_array[handle].is_open)
    {
      (void) BestLastErrorSet(handle, B_E_BAD_HANDLE);
    }
  }

#else

  fprintf (stderr, "Invalid handle used to set error.");
  exit (1);

#endif
  
}


/* --------------------------------------------------------------------------
 * Internally used error functions
 * -------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------
 * This function is used by ALL parameter checking routines to record
 * the error if the  check fails.  It is aliased by the macro __FCT_PARAM_MSG
 * which is called by the B_FCT_PARAM_CHK series of macros.
 * -------------------------------------------------------------------------- */

void EXPORT BestFuncParamMsg(
    b_handletype handle,
    b_ccharptrtype pFuncName,
    b_ccharptrtype param,
    b_ccharptrtype reason)
{
  char s1[256];
  strcpy(s1, pFuncName);
  strcat(s1, "@");
  strcat(s1, param);
  strcat(s1, "@");
  strcat(s1, reason);
  BestLastErrorParamStringSet(handle, s1);
}



/* --------------------------------------------------------------------------
 * Exported error functions
 * -------------------------------------------------------------------------- */

b_ccharptrtype EXPORT BestErrorStringGet(
    b_errtype error
)
{
  /* NEW: Now with comments because of special request from Henrik, actually
   * I just changed the font color from white to black. CZ */
   /* Well Christian, sometimes a little comment helps a lot in understanding
   * of what was actually meant.... */

  b_ccharptrtype msg;
  b_handletype handle;
  /* scan through all handles to look for the error message */

  for (handle = 0; handle < MAXHANDLES; ++handle)
  {
    if ((handle_array[handle].is_open) &&
      (handle_array[handle].lasterr.lasterr_err == error))
    {
      msg = handle_array[handle].lasterr.lasterr_msg;
      goto msg_label;
    }
  }

  /* not found, maybe it's stored with a close ? */
  if (es_storeforclose.lasterr_err == error)
  {
    msg = es_storeforclose.lasterr_msg;
    goto msg_label;
  }

  /* not found, maybe it's a handleless problem */
  if (es_handleless.lasterr_err == error)
  {
    msg = es_handleless.lasterr_msg;
    goto msg_label;
  }

  /* moved before, TW + HL, not found, maybe it's stored with a close ? */
  /*if (es_storeforclose.lasterr_err == error)
  {
    msg = es_storeforclose.lasterr_msg;
    goto msg_label;
  } */


  /* no according error found, just return the format string */
  if (error > B_E_FIRMWARE)
  {
    if (error > B_EFW_LAST_ENTRY)
    {
      msg = ErrDescFromList(B_E_UNKNOWN_ERR)->error;
    }
    else
    {
      msg = ErrDescFromList(error)->error;
    }
  }

  else
  {
    if (error > B_E_LAST_ENTRY)
    {
      msg = ErrDescFromList(B_E_UNKNOWN_ERR)->error;
    }
    else
    {
      if (error == B_E_PERFBOARD_ERROR)
      {
        msg = perfboard_err;
      }
      else
      {
        msg = ErrDescFromList(error)->error;
      }
    }
  }

msg_label:

  if (msg && !msg[0])
    msg = NULL;

  return msg;
}



void EXPORT BestLastErrorParamSet(b_handletype handle, b_errparamtype index, b_int64 errpar)
{
  assert(index < B_ERROR_NUMPARAMS);

  if (__HANDLECHECK)
  {
    handle_array[handle].lasterr.lasterr_par[index] = errpar;
  }
  else
  {
    es_handleless.lasterr_par[index] = errpar;
    handle_problem();
  }
}


void EXPORT BestLastErrorAllParamsSet(b_handletype handle,
    b_int64 errpar1, b_int64 errpar2,
    b_int64 errpar3, b_int64 errpar4,
    b_int64 errpar5)
{
  if (__HANDLECHECK)
  {
    handle_array[handle].lasterr.lasterr_par[B_ERRPAR_1] = errpar1;
    handle_array[handle].lasterr.lasterr_par[B_ERRPAR_2] = errpar2;
    handle_array[handle].lasterr.lasterr_par[B_ERRPAR_3] = errpar3;
    handle_array[handle].lasterr.lasterr_par[B_ERRPAR_4] = errpar4;
    handle_array[handle].lasterr.lasterr_par[B_ERRPAR_5] = errpar5;
  }

  else
  {
    es_handleless.lasterr_par[B_ERRPAR_1] = errpar1;
    es_handleless.lasterr_par[B_ERRPAR_2] = errpar2;
    es_handleless.lasterr_par[B_ERRPAR_3] = errpar3;
    es_handleless.lasterr_par[B_ERRPAR_4] = errpar4;
    es_handleless.lasterr_par[B_ERRPAR_5] = errpar5;
    handle_problem();
  }
}


void EXPORT BestLastErrorAllParamsGet(b_handletype handle,
    b_int64ptr errpar1, b_int64ptr errpar2,
    b_int64ptr errpar3, b_int64ptr errpar4,
    b_int64ptr errpar5)
{
  if (__HANDLECHECK)
  {
    *errpar1 = handle_array[handle].lasterr.lasterr_par[B_ERRPAR_1];
    *errpar2 = handle_array[handle].lasterr.lasterr_par[B_ERRPAR_2];
    *errpar3 = handle_array[handle].lasterr.lasterr_par[B_ERRPAR_3];
    *errpar4 = handle_array[handle].lasterr.lasterr_par[B_ERRPAR_4];
    *errpar5 = handle_array[handle].lasterr.lasterr_par[B_ERRPAR_5];
  }

  else
  {
    *errpar1 = es_handleless.lasterr_par[B_ERRPAR_1];
    *errpar2 = es_handleless.lasterr_par[B_ERRPAR_2];
    *errpar3 = es_handleless.lasterr_par[B_ERRPAR_3];
    *errpar4 = es_handleless.lasterr_par[B_ERRPAR_4];
    *errpar5 = es_handleless.lasterr_par[B_ERRPAR_5];
    handle_problem();
  }
}


void EXPORT BestLastErrorParamStringSet(b_handletype handle, b_ccharptrtype s)
{
  /* check before we strcpy into outer space */

  if (strlen(s) > B_LASTERR_STRING)
  {
    assert(strlen(s) <= B_LASTERR_STRING);
    return;
  }

  if (__HANDLECHECK)
  {
    strcpy(handle_array[handle].lasterr.lasterr_str, s);
  }
  else
  {
    strcpy(es_handleless.lasterr_str, s);
  }
}


/* --------------------------------------------------------------------------
 * Set last error...will also set last error to B_E_OK !!!
 * -------------------------------------------------------------------------- */

b_errtype EXPORT BestLastErrorSet(b_handletype handle, b_errtype err)
{
  int i, buf_offset = 0;
  char *msg_buf;
  char str_buf[B_LASTERR_STRING];
  char *str_ptr;
  char *str_ptr2;
  b_errtype tmp_err;
  b_lasterrtype *ref_lasterr;
  b_lasterrtype buf_lasterr;
  const ErrorDescription * ed = NULL;

  ref_lasterr = ((__HANDLECHECK) ?
    &handle_array[handle].lasterr : &es_handleless);

  /* out of bounds ? */

  if ((err > B_EFW_LAST_ENTRY) ||
    ((err <= B_E_FIRMWARE) && (err > B_E_LAST_ENTRY)))
  {
    BestLastErrorParamSet(handle, B_ERRPAR_1, (b_int32)err);
    (void) BestLastErrorSet(handle, B_E_UNKNOWN_ERR);
    ref_lasterr->lasterr_err = err;
    return err;
  }

  ed = ErrDescFromList(err);

  if (ed && ed->error)
  {
    if (err)
    {
      /* add msg and setup msg_buf to point to the next empty character */
      buf_offset = sprintf(ref_lasterr->lasterr_msg, "%s:\n", ed->errname);
      msg_buf = &ref_lasterr->lasterr_msg[buf_offset];
    }
    else
    {
      msg_buf = ref_lasterr->lasterr_msg;
      msg_buf[0] = '\0';
    }

    switch (err)
    {
    case B_E_VALUE:
    case B_E_RANGE:
    case B_E_ALIGN:
    case B_E_PARAM_NOT_EXIST:
    case B_EFW_VALUE:
    case B_EFW_RANGE:
    case B_EFW_ALIGN:
    case B_EFW_PARAM_NOT_EXIST:
      if (ref_lasterr->lasterr_par[B_ERRPAR_1] == (b_int32)B_PARAM_CUSTOM)
      {
	if (handle_array[handle].lasterr.lasterr_par[B_ERRPAR_2] > (b_int32)B_PCST_LAST)
	  handle_array[handle].lasterr.lasterr_par[B_ERRPAR_2] = (b_int32)B_PCST_UNKNOWN;
	
        errsprintf(msg_buf, ed->error,
          (b_int64)pcst_list[(int) handle_array[handle].lasterr.lasterr_par[B_ERRPAR_2]],
          ref_lasterr->lasterr_par[B_ERRPAR_3],
          ref_lasterr->lasterr_par[B_ERRPAR_4],
          ref_lasterr->lasterr_par[B_ERRPAR_5],
          0);
      }
      else
      {
        assert(ref_lasterr->lasterr_par[B_ERRPAR_1] < (b_int32)B_PARAM_LAST);
        memcpy(&buf_lasterr, ref_lasterr, sizeof buf_lasterr);
        (void) BestDynamicErrorStringGet(
          handle,
          handle_array[handle].lasterr.lasterr_par[B_ERRPAR_1],
          handle_array[handle].lasterr.lasterr_par[B_ERRPAR_2],
          handle_array[handle].lasterr.lasterr_par[B_ERRPAR_3],
          handle_array[handle].lasterr.lasterr_par[B_ERRPAR_4],
          handle_array[handle].lasterr.lasterr_par[B_ERRPAR_5],
          err,
          &buf_lasterr.lasterr_msg[buf_offset]
          );
        memcpy(ref_lasterr, &buf_lasterr, sizeof buf_lasterr);
      }

      break;

    case B_E_CORE_VERSION_MISMATCH:
      {
        char str2[15];
        char str3[15];
        /* file core version */
        strcpy(str2, CoreVerString(ref_lasterr->lasterr_par[B_ERRPAR_1]));
        /* actual core version */
        strcpy(str3, CoreVerString(ref_lasterr->lasterr_par[B_ERRPAR_2]));
        sprintf(msg_buf, ed->error,
          ref_lasterr->lasterr_str, /* file fw version */
          str2, str3);

      }
      break;

     case B_EFW_PATT_SYNTAX:
     case B_EFW_PATT_UNDEF_TOKEN:
     case B_EFW_PATT_MTO_LISTSIGNAL:
      /* ATTENTION: recursive == don't touch!! */
      /* get additional information for a nice error message */
      /* TODO: How to make result of BestPattGetEdit 'dont't touch'? */
     
      memcpy(&buf_lasterr, ref_lasterr, sizeof buf_lasterr);
      tmp_err = BestPattGetEdit(handle,
        ref_lasterr->lasterr_par[B_ERRPAR_1],
        ((b_ccharptrtype *) &str_ptr));
      memcpy(ref_lasterr, &buf_lasterr, sizeof buf_lasterr);

      if (tmp_err)
      {
        /* everything changed, replace current error with the error from
         * BestPattGetEdit */
        err = tmp_err;
      }

      else
      {
        BestLastErrorParamStringSet(handle, str_ptr);

        /* following code is very similar to syntax error */
        msg_buf = ref_lasterr->lasterr_msg;
        errsprintf(str_buf, ed->error, ref_lasterr->lasterr_par[B_ERRPAR_1],0,0,0,0);
        strcat(msg_buf, str_buf);
        strcat(msg_buf, "\n");
        strcat(msg_buf, (char *)ref_lasterr->lasterr_str);
        strcat(msg_buf, "\n");

        for (i = 0; i < (int) ref_lasterr->lasterr_par[B_ERRPAR_2]; ++i)
        {
          strcat(msg_buf, " ");
        }

        strcat(msg_buf, "^");
      }

      break;

    case B_E_SYNTAX:
    case B_EFW_SYNTAX:
      msg_buf = ref_lasterr->lasterr_msg;
      strcat(msg_buf, ed->error);
      strcat(msg_buf, "\n");
      strcat(msg_buf, ref_lasterr->lasterr_str);
      strcat(msg_buf, "\n");

      for (i = 0; i < (int) ref_lasterr->lasterr_par[B_ERRPAR_1]; ++i)
      {
        strcat(msg_buf, " ");
      }

      strcat(msg_buf, "^");
      break;

    case B_E_FCT_PARAM:
      strcpy(str_buf, ref_lasterr->lasterr_str);
      str_ptr2 = str_ptr = strchr(str_buf, '@');

      if (str_ptr)
      {
        str_ptr2 = strchr(str_ptr, '@');
        *str_ptr++ = '\0';

        if (str_ptr2)
        {
          *str_ptr2++ = '\0';
        }
      }

      sprintf(msg_buf, ed->error, str_buf,
        str_ptr ? str_ptr : "unknown",
        str_ptr2 ? str_ptr2 : "unknown reason");
      break;

    case B_E_VERSION_MISMATCH:
      strcpy(str_buf, ref_lasterr->lasterr_str);
      if (NULL != (str_ptr = strchr(str_buf, '@')))
      {
        *str_ptr++ = '\0';
        sprintf(msg_buf, ed->error,
          str_buf,
          verchk_list[(int) handle_array[handle].lasterr.lasterr_par[B_ERRPAR_1]],
          str_ptr);
      }
      break;

    case B_E_UNDERFLOW:
    case B_E_OVERFLOW:
    case B_E_FILE_OPEN:
    case B_E_BAD_FILE_FORMAT:
    case B_E_PPR_OUT_OF_RANGE:
      sprintf(msg_buf, ed->error, ref_lasterr->lasterr_str);
      break;

    case B_E_FILE_ITEM_NOT_FOUND:
      errsprintf(msg_buf, ed->error,
        ref_lasterr->lasterr_par[B_ERRPAR_1],
        (b_int64)ref_lasterr->lasterr_str,0,0,0);
      break;

    default:
      errsprintf(msg_buf, ed->error,
        (ed->lookup1 ?
          (b_int64) ed->lookup1[(int) handle_array[handle].
            lasterr.lasterr_par[B_ERRPAR_1]] :
          ref_lasterr->lasterr_par[B_ERRPAR_1]),
        (ed->lookup2 ?
          (b_int64) ed->lookup2[(int) handle_array[handle].
            lasterr.lasterr_par[B_ERRPAR_2]] :
          ref_lasterr->lasterr_par[B_ERRPAR_2]),
        (ed->lookup3 ?
          (b_int64) ed->lookup3[(int) (handle_array[handle].
            lasterr.lasterr_par[B_ERRPAR_3])] :
          ref_lasterr->lasterr_par[B_ERRPAR_3]),
        (ed->lookup4 ?
          (b_int64) ed->lookup4[(int) handle_array[handle].
            lasterr.lasterr_par[B_ERRPAR_4]] :
          ref_lasterr->lasterr_par[B_ERRPAR_4]),
        (ed->lookup5 ?
          (b_int64) ed->lookup5[(int) handle_array[handle].
            lasterr.lasterr_par[B_ERRPAR_5]] :
          ref_lasterr->lasterr_par[B_ERRPAR_5]));
      break;
    }                           /*lint !e788 not all enums used */
  }                             /* if (ed && ed->error) */
  else
  {
    ref_lasterr->lasterr_msg[0] = '\0';
  }

  ref_lasterr->lasterr_err = err;

  /* MUST return the same param we got in order for macros to work properly */
  return err;
}



b_errtype EXPORT BestLastErrorGet(b_handletype handle)
{
  if (__HANDLECHECK)
    return handle_array[handle].lasterr.lasterr_err;

  return B_E_BAD_HANDLE;
}


b_ccharptrtype EXPORT BestLastErrorStringGet(b_handletype handle)
{
  b_ccharptrtype msg;
  if (__HANDLECHECK)
  {
    msg = handle_array[handle].lasterr.lasterr_msg;
  }
  else
  {
    msg = BestErrorStringGet(B_E_BAD_HANDLE);
  }

  if (msg && !msg[0])
    msg = NULL;

  return msg;
}


void BestLastErrorStore(b_handletype handle, b_errtype err)
{
  /* We're about to loose the handle but maybe still do need the last error
   * message. Put it in a single linked global list */

  if (!__HANDLECHECK)
  {
    return;
  }

  if (handle_array[handle].lasterr.lasterr_err == err)
  {
    /* seems okay, lets copy it into the handleless  */
    memcpy(&es_storeforclose, &handle_array[handle].lasterr,
      sizeof(b_lasterrtype));
  }
}
